/***************************************************************************
                          LOW_IPCKeyGenerator.h  -  description
                             -------------------
    begin                : Tue Jul 30 2002
    copyright            : (C) 2002 by Harald Roelle, Helmut Reiser
    email                : roelle@informatik.uni-muenchen.de, reiser@informatik.uni-muenchen.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef LOW_IPCKEYGENERATOR_H
#define LOW_IPCKEYGENERATOR_H


#include "LOW_portSerialFactory.h"
#include "LOW_semaphoreSetFactory.h"
#include "LOW_sharedMemSegmentFactory.h"
#include "LOW_IPCKeyGeneratorFactory.h"
#include "LOW_deviceID.h"



/** Abstract base class for IPC key generators.
    Each instance represents one IPC key generator.

    Specific platforms dereive their implementation classes from this class.

    The instances are created by LOW_IPCKeyGeneratorFactory, following the factory
    design pattern.

    <B>Note:</B> There is no prescribed constructor.

    @see LOW_IPCKeyGeneratorFactory

    @author Harald Roelle, Helmut Reiser
 */
class LOW_IPCKeyGenerator {

//=======================================================================================
public: 
  
  //=====================================================================================
  //
  // methods
  //

  /** Get new semaphore set unique identifier from serial port identifier.
      @param   Reference to serial port identifier.
      @return  New semaphore set unique identifier.
   */
  virtual LOW_semaphoreSetFactory::semSetIPCKey_t getSemSetKey(  const LOW_portSerialFactory::portSpecifier_t &inSerPortSpec) = 0;
  
  /** Get new semaphore set unique identifier from device ID.
      @param   Reference to device ID.
      @return  New semaphore set unique identifier.
   */
  virtual LOW_semaphoreSetFactory::semSetIPCKey_t getSemSetKey(  const LOW_deviceID &inDevID) = 0;
  
  /** Get new shared memory unique identifier from serial port identifier.
      @param   Reference to serial port identifier.
      @return  New shared memory unique identifier.
   */
  virtual LOW_sharedMemSegmentFactory::sharedMemSegmentIPCKey_t getSharedMemKey(  const LOW_portSerialFactory::portSpecifier_t &inSerPortSpec) = 0;

};

#endif
