/***************************************************************************
                          LOW_semaphoreSetSysV.cpp  -  description
                             -------------------
    begin                : Mon Jul 29 2002
    copyright            : (C) 2002 by Harald Roelle, Helmut Reiser
    email                : roelle@informatik.uni-muenchen.de, reiser@informatik.uni-muenchen.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include <memory>
 
#include <unistd.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/sem.h>
#include <sys/types.h>


#include "LOW_semaphoreSet_SysV.h"


//=====================================================================================
//
// constructors
//

LOW_semaphoreSet_SysV::LOW_semaphoreSet_SysV( const LOW_semaphoreSetFactory::semSetIPCKey_t inKey, const unsigned int inSemCount, const unsigned int inInitVal) :
  semSetKey( inKey)
{
  if ( (semSetID=semget( semSetKey, inSemCount, SEM_PERMS)) == -1 ) {
  
    if ( errno == ENOENT ) {  // existed not yet, so create new set

      if ( (semSetID=semget( semSetKey, inSemCount, SEM_PERMS | IPC_CREAT)) == -1 )  // create set
        throw semSet_error( errno, "Failed to create new semaphore set", __FILE__, __LINE__);

      unsigned short *initVal = (unsigned short *)malloc( sizeof( unsigned short) * inSemCount);  // cannnot use auto_ptr
      for( unsigned int a=0; a<inSemCount; ++a)
        initVal[a] = inInitVal;
        
      int retVal = semctl( semSetID, 0, SETALL, initVal);  // init semaphore values
      
      free( initVal);
      
      if ( retVal == -1 )
        throw semSet_error( errno, "Failed to set initial semaphore values", __FILE__, __LINE__);

    }
    else {
      throw semSet_error( errno, "Error getting semaphore set", __FILE__, __LINE__);
    }
  }
}


LOW_semaphoreSet_SysV::~LOW_semaphoreSet_SysV()
{
  semctl( semSetID, 0, IPC_RMID);
}



//=====================================================================================
//
// methods
//

void LOW_semaphoreSet_SysV::decSem( const unsigned int inSemNo) const
{
  // isInitialized checking not necessary. semop() will fail anyway
  
  struct sembuf  semAction;

  semAction.sem_num = inSemNo;
  semAction.sem_op  = -1;
  semAction.sem_flg = SEM_UNDO;

  if ( semop( semSetID, &semAction, 1) == -1 )
    throw semSet_error( errno, "semop() failed when decreasing semaphore", __FILE__, __LINE__);
}


void LOW_semaphoreSet_SysV::incSem( const unsigned int inSemNo) const
{
  // isInitialized checking not necessary. semop() will fail anyway
  
  struct sembuf  semAction;

  semAction.sem_num = inSemNo;
  semAction.sem_op  = 1;
  semAction.sem_flg = SEM_UNDO;

  if ( semop( semSetID, &semAction, 1) == -1 )
    throw semSet_error( errno, "semop() failed when increasing semaphore", __FILE__, __LINE__);
}
