/***************************************************************************
                          LOW_platformMisc_Linux.h  -  description
                             -------------------
    begin                : Thu Aug 1 2002
    copyright            : (C) 2002 by Harald Roelle, Helmut Reiser
    email                : roelle@informatik.uni-muenchen.de, reiser@informatik.uni-muenchen.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef LOW_PLATFORMMISC_LINUX_H
#define LOW_PLATFORMMISC_LINUX_H


#include "LOW_platformMisc.h"


/** Platform specific miscelanious for Linux platforms.

    @author Harald Roelle, Helmut Reiser
 */
class LOW_platformMisc_Linux : public LOW_platformMisc {

//=======================================================================================
public: 

  //=====================================================================================
  //
  // methods
  //
  
  void const p_secSleep( const unsigned int inSeconds);
  void const p_milliSleep( const unsigned long inMilliSeconds);
  void const p_microSleep( const unsigned long inMicroSeconds);
  void const p_nanoSleep( const unsigned long inNanoSeconds);
  void const p_nanoSleep( const unsigned int inSeconds, const unsigned long inNanoSeconds);

  void const p_getTimestamp( LOW_platformMisc::timestamp_t &outTimestamp);

  LOW_platformMiscFactory::threadIdent_t  const p_getThreadID();

  std::string const p_getHostname();
};

#endif
